/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon;

import device.DeviceList;
import device.SensorNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javafx.fxml.FXML;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.XYChart;
import project.Project;

public class EnergyDrawController {
    @FXML
    public LineChart<String, Double> lineChart;

    @FXML
    public void battery() {
        this.lineChart.getXAxis().setAutoRanging(true);
        this.lineChart.getYAxis().setAutoRanging(true);
        int idx = 1;
        double n = 0.0;
        double cv = 0.0;
        double sum = 0.0;
        for (SensorNode sensor : DeviceList.sensors) {
            if (sensor.isSelected()) {
                n += 1.0;
                XYChart.Series series = new XYChart.Series();
                series.setName(sensor.getName());
                String fileName = Project.getProjectResultPath() + File.separator + "wisen_simulation.csv";
                try {
                    FileReader fr = new FileReader(fileName);
                    BufferedReader br = new BufferedReader(fr);
                    br.readLine();
                    String s = "";
                    while ((s = br.readLine()) != null) {
                        double y;
                        String[] t = s.split(";");
                        String sx = String.format("%2.2f", Double.parseDouble(t[0])).replaceAll(",", ".");
                        String sy = String.format("%2.2f", Double.parseDouble(t[idx]));
                        cv = y = Double.parseDouble(sy.replaceAll(",", "."));
                        XYChart.Data<String, Double> data = new XYChart.Data<String, Double>(sx, y);
                        series.getData().add(data);
                    }
                    br.close();
                    sum += cv;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.lineChart.getData().add(series);
            }
            ++idx;
        }
        System.out.println(sum / n);
    }

    @FXML
    public void consumption() {
        this.lineChart.getXAxis().setAutoRanging(true);
        this.lineChart.getYAxis().setAutoRanging(true);
        int idx = 1;
        for (SensorNode sensor : DeviceList.sensors) {
            if (sensor.isSelected()) {
                XYChart.Series series = new XYChart.Series();
                series.setName(sensor.getName());
                series.getData().removeAll(series.getData());
                String fileName = Project.getProjectResultPath() + File.separator + "wisen_simulation.csv";
                try {
                    FileReader fr = new FileReader(fileName);
                    BufferedReader br = new BufferedReader(fr);
                    br.readLine();
                    String s = "";
                    s = br.readLine();
                    String[] t = s.split(";");
                    String sx = String.format("%2.2f", Double.parseDouble(t[0])).replaceAll(",", ".");
                    String sy = String.format("%2.2f", Double.parseDouble(t[idx]));
                    double y0 = Double.parseDouble(sy.replaceAll(",", "."));
                    while ((s = br.readLine()) != null) {
                        t = s.split(";");
                        sx = String.format("%2.2f", Double.parseDouble(t[0])).replaceAll(",", ".");
                        sy = String.format("%2.2f", Double.parseDouble(t[idx]));
                        double y = Double.parseDouble(sy.replaceAll(",", "."));
                        XYChart.Data<String, Double> data = new XYChart.Data<String, Double>(sx, y0 - y);
                        y0 = y;
                        series.getData().add(data);
                    }
                    br.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.lineChart.getData().add(series);
            }
            ++idx;
        }
    }

    @FXML
    public void batteryTotal() {
    }

    @FXML
    public void batteryAverage() {
    }
}

