/*
 * Decompiled with CFR 0.152.
 */
package cupcarbon_script;

import cupcarbon_script.CupConditionElement;
import cupcarbon_script.CupConditionElementAnd;
import cupcarbon_script.CupConditionElementEnd;
import cupcarbon_script.CupConditionElementOr;
import cupcarbon_script.CupScript;

public class CupEvalCondition {
    protected CupScript script;

    public CupEvalCondition(CupScript script) {
        this.script = script;
    }

    public CupConditionElement initCondition(String condition) {
        condition = condition.replaceAll(" ", "");
        int frst = condition.indexOf("(");
        int last = condition.lastIndexOf(")");
        if (frst == 0 && last == condition.length() - 1 && condition.indexOf("(", frst + 1) < condition.indexOf(")", frst + 1)) {
            condition = condition.substring(frst + 1, last);
        }
        if (this.getNbConditions(condition) == 0) {
            CupConditionElementEnd cond = new CupConditionElementEnd(this.script, condition);
            return cond;
        }
        String[] tCondition = this.getTwoParts(condition);
        if (tCondition == null) {
            return null;
        }
        if (tCondition[2] == "&&") {
            CupConditionElementAnd cond = new CupConditionElementAnd(this.initCondition(tCondition[0]), this.initCondition(tCondition[1]));
            return cond;
        }
        if (tCondition[2] == "||") {
            CupConditionElementOr cond = new CupConditionElementOr(this.initCondition(tCondition[0]), this.initCondition(tCondition[1]));
            return cond;
        }
        return null;
    }

    public String[] getTwoParts(String condition) {
        String block2;
        String block1;
        String[] res = new String[3];
        int fromIndex = 0;
        int idxAnd = condition.indexOf("&&", fromIndex);
        while (idxAnd != -1) {
            block1 = condition.substring(0, idxAnd);
            block2 = condition.substring(idxAnd + 2, condition.length());
            res[0] = block1;
            res[1] = block2;
            res[2] = "&&";
            if (this.correctNbBrackets(block1) && this.correctNbBrackets(block2)) {
                return res;
            }
            fromIndex = idxAnd + 2;
            idxAnd = condition.indexOf("&&", fromIndex);
        }
        idxAnd = condition.indexOf("||");
        while (idxAnd != -1) {
            block1 = condition.substring(0, idxAnd);
            block2 = condition.substring(idxAnd + 2, condition.length());
            res[0] = block1;
            res[1] = block2;
            res[2] = "||";
            if (this.correctNbBrackets(block1) && this.correctNbBrackets(block2)) {
                return res;
            }
            fromIndex = idxAnd + 2;
            idxAnd = condition.indexOf("||", fromIndex);
        }
        return null;
    }

    public int getNbConditions(String condition) {
        int compBrOPen = 0;
        int compBrClose = 0;
        for (int i = 0; i < condition.length(); ++i) {
            if (condition.charAt(i) == '(') {
                ++compBrOPen;
                continue;
            }
            if (condition.charAt(i) != ')') continue;
            ++compBrClose;
        }
        if (compBrOPen == compBrClose) {
            return compBrOPen;
        }
        return -1;
    }

    public boolean correctNbBrackets(String condition) {
        int compBrOPen = 0;
        int compBrClose = 0;
        for (int i = 0; i < condition.length(); ++i) {
            if (condition.charAt(i) == '(') {
                ++compBrOPen;
                continue;
            }
            if (condition.charAt(i) != ')') continue;
            ++compBrClose;
        }
        return compBrOPen == compBrClose;
    }
}

