/*
 * Decompiled with CFR 0.152.
 */
package device;

import battery.Battery;
import device.DeviceList;
import device.DeviceWithRadio;
import device.MapObject;
import device.SensorNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.LinkedList;
import java.util.Random;
import map.MapLayer;
import map.NetworkParameters;
import senscript.SenScript;
import simulation.SimulationInputs;
import utilities.MapCalc;
import utilities.UColor;
import visibility.VisibilityZones;

public abstract class Device
extends MapObject
implements Cloneable {
    public static final int NONE = 0;
    public static final int SENSOR = 1;
    public static final int GAS = 2;
    public static final int FLYING_OBJECT = 3;
    public static final int BASE_STATION = 4;
    public static final int DIRECTIONAL_SENSOR = 5;
    public static final int MOBILE = 6;
    public static final int WEATHER = 7;
    public static final int MARKER = 8;
    public static final int VERTEX = 9;
    public static final int BUILDING = 10;
    public static final int GEOZONE = 11;
    public static final int RSENSOR = 12;
    public static final int IOT = 13;
    public static final int RIOT = 14;
    public static final boolean DEAD = false;
    public static final boolean ALIVE = true;
    public static final boolean SLEEP = false;
    protected boolean action = false;
    protected double sigmaOfDriftTime = 3.0E-5;
    protected double driftTime = 1.0;
    public static int moveSpeed = 100;
    protected int idm = 0;
    protected Battery battery;
    protected long uartDataRate = 9600L;
    protected boolean underSimulation = false;
    protected boolean withRadio = false;
    protected boolean withSensor = false;
    protected boolean mobile = false;
    protected boolean displayRadius = false;
    protected boolean visited = false;
    protected boolean drawBatteryLevel = false;
    protected String[][] infos = new String[][]{{"SENSOR: ", ""}, {"ID: ", ""}, {"MY: ", ""}, {"Network ID: ", ""}, {"Channel: ", ""}, {"Script: ", ""}, {"GPS: ", ""}, {"Battery: ", ""}};
    protected boolean displayInfos = false;
    protected String scriptFileName = "";
    protected String gpsFileName = "";
    protected String gpsFileName_ori = "";
    protected String nateventFileName = "";
    protected SenScript script = null;
    protected String targetName = "";
    protected int ledColor = 0;
    protected Color radioLinkColor = new Color(221, 0, 0, 190);
    protected boolean receiving = false;
    protected boolean sending = false;
    protected boolean writing = false;
    protected long distanceModeDelay = 2000L;
    protected boolean state = true;
    protected boolean marked = false;
    protected double value = 0.0;
    protected LinkedList<Double> valueList;
    protected double event = Double.MAX_VALUE;
    protected double event2 = Double.MAX_VALUE;
    protected double event3 = Double.MAX_VALUE;
    protected Thread thread;
    protected String message = "";
    private Random random = new Random();

    public Device() {
    }

    public Device(double x, double y, double z, double radius, int id) {
        super(x, y, z, radius, id);
    }

    public void setGPSFileName(String gpsFileName) {
        this.gpsFileName = gpsFileName.endsWith(".gps") ? gpsFileName : "";
    }

    public String getGPSFileName() {
        return this.gpsFileName;
    }

    public String getNatEventFileName() {
        return this.nateventFileName;
    }

    public void setNatEventFileName(String nateventFileName) {
        this.nateventFileName = nateventFileName.endsWith(".evt") ? nateventFileName : "";
    }

    public abstract void drawMarked(Graphics var1);

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setScriptFileName(String scriptFileName) {
        this.scriptFileName = scriptFileName;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    public void setInfos(String[][] infos) {
        this.infos = infos;
    }

    public String[][] getInfos() {
        this.infos[0][1] = "S" + this.id;
        this.infos[1][1] = "" + this.id;
        this.infos[5][1] = this.scriptFileName;
        this.infos[6][1] = this.gpsFileName;
        this.infos[7][1] = this.getBatteryLevelInPercent() + " % [" + (int)this.getBatteryConsumption() + "]";
        return this.infos;
    }

    public void setMarked(boolean b) {
        this.ledColor = b ? 1 : 0;
        this.marked = b;
    }

    public void setMarked(int color) {
        this.ledColor = color;
        this.marked = color != 0;
    }

    public void mark(String scolor) {
        this.ledColor = Integer.parseInt(scolor);
        this.setMarked(this.ledColor);
        MapLayer.repaint();
    }

    public void mark(int color) {
        this.ledColor = color;
        this.marked = true;
        MapLayer.repaint();
    }

    public void mark() {
        this.ledColor = 1;
        this.marked = true;
        MapLayer.repaint();
    }

    public void unmark() {
        this.ledColor = 0;
        this.marked = false;
        MapLayer.repaint();
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setDead(boolean dead) {
        if (dead) {
            this.marked = false;
            this.getBattery().setLevel(0.0);
        }
    }

    public boolean isDead() {
        return this.getBatteryLevel() <= 0.0;
    }

    public boolean withRadio() {
        return this.withRadio;
    }

    public double getMaxRadius() {
        return this.radius;
    }

    public double distanceInPixel(Device device) {
        double x2 = device.getLongitude();
        double y2 = device.getLatitude();
        return MapCalc.distanceInPixels(this.longitude, this.latitude, x2, y2);
    }

    public double distance(double x, double y) {
        return MapCalc.distance(this.longitude, this.latitude, x, y);
    }

    public double distance(Device device) {
        double x2 = device.getLongitude();
        double y2 = device.getLatitude();
        return MapCalc.distance(this.longitude, this.latitude, x2, y2);
    }

    public double distance(int id) {
        DeviceWithRadio device = (DeviceWithRadio)DeviceList.getNodeById(id);
        if (!this.radioDetect(device)) {
            return -1.0;
        }
        double x2 = device.getLongitude();
        double y2 = device.getLatitude();
        return MapCalc.distance(this.longitude, this.latitude, x2, y2);
    }

    public double distance2(int id) {
        DeviceWithRadio device = (DeviceWithRadio)DeviceList.getNodeById(id);
        double x2 = device.getLongitude();
        double y2 = device.getLatitude();
        return MapCalc.distance(this.longitude, this.latitude, x2, y2);
    }

    public double distanceX(Device device) {
        double x2 = device.getLongitude();
        return MapCalc.distance(this.longitude, this.latitude, x2, this.latitude);
    }

    public double distanceY(Device device) {
        double y2 = device.getLatitude();
        return MapCalc.distance(this.longitude, this.latitude, this.longitude, y2);
    }

    public void setId() {
        this.id = DeviceList.number++;
    }

    public void stopAgentSimulation() {
        if (this.thread != null) {
            this.thread.stop();
            this.longitude = this.longitude_ori;
            this.latitude = this.latitude_ori;
        }
        this.thread = null;
        this.underSimulation = false;
        MapLayer.repaint();
    }

    public void stopSimByAlgo() {
        this.thread = null;
        this.underSimulation = false;
        MapLayer.repaint();
    }

    public void agentSimulation() {
        if (this.selected) {
            this.selected = false;
            this.start();
        }
    }

    public void drawRadius(int x, int y, int r, Graphics g) {
    }

    public boolean displayInfos() {
        return this.displayInfos;
    }

    public void drawInfos(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(0.6f));
        if (this.displayInfos && this.selected && this.infos != null) {
            g.setFont(new Font("arial", 1, 10));
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int lx1 = coord[0];
            int ly1 = coord[1];
            g.setColor(UColor.WHITE_TRANSPARENT);
            g.fillRect(lx1 + 20, ly1 - 25, 150, 90);
            g.setColor(UColor.BLACK_TRANSPARENT);
            g.drawRect(lx1 + 20, ly1 - 25, 150, 90);
            g.setColor(Color.black);
            g.drawString(this.getInfos()[0][0] + this.getInfos()[0][1], lx1 + 30, ly1 - 10);
            g.drawString(this.getInfos()[1][0] + this.getInfos()[1][1], lx1 + 30, ly1);
            g.drawString(this.getInfos()[2][0] + this.getInfos()[2][1], lx1 + 30, ly1 + 10);
            g.drawString(this.getInfos()[3][0] + this.getInfos()[3][1], lx1 + 30, ly1 + 20);
            g.drawString(this.getInfos()[4][0] + this.getInfos()[4][1], lx1 + 30, ly1 + 30);
            g.drawString(this.getInfos()[5][0] + this.getInfos()[5][1], lx1 + 30, ly1 + 40);
            g.drawString(this.getInfos()[6][0] + this.getInfos()[6][1], lx1 + 30, ly1 + 50);
            g.drawString(this.getInfos()[7][0] + this.getInfos()[7][1], lx1 + 30, ly1 + 60);
        }
    }

    public Device duplicateByConsole() throws CloneNotSupportedException {
        Device newNode = (Device)super.clone();
        newNode.setId();
        newNode.setScriptFileName(this.scriptFileName);
        newNode.setGPSFileName(this.gpsFileName);
        newNode.setLongitude(this.getLongitude() + 1.0E-4);
        newNode.setLatitude(this.getLatitude() + 1.0E-4);
        newNode.setElevation(this.getElevation());
        return newNode;
    }

    public Device clone() throws CloneNotSupportedException {
        Device newNode = (Device)super.clone();
        newNode.setId();
        newNode.setScriptFileName(this.scriptFileName);
        newNode.setGPSFileName(this.gpsFileName);
        return newNode;
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        } else {
            System.out.println("Simulation is running for node " + this.getName());
        }
    }

    public double getBatteryLevel() {
        if (this.getBattery() != null) {
            return this.getBattery().getLevel();
        }
        return 0.0;
    }

    public void setBatteryLevel(double level) {
        if (this.getBattery() != null) {
            this.getBattery().setLevel(level);
        }
    }

    public int getBatteryLevelInPercent() {
        return this.getBattery().getLevelInPercent();
    }

    public double getBatteryConsumption() {
        return this.getBattery().getBatteryConsumption();
    }

    public Battery getBattery() {
        return this.battery;
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Thread getThread() {
        return this.thread;
    }

    public static void initNumber() {
        DeviceList.number = 1;
    }

    public static void incNumber() {
        ++DeviceList.number;
    }

    public void fixori() {
        this.longitude_ori = this.longitude;
        this.latitude_ori = this.latitude;
        this.elevation_ori = this.elevation;
        this.gpsFileName_ori = this.gpsFileName;
        if (SimulationInputs.visibility && (this.getType() == 1 || this.getType() == 5 || this.getType() == 4)) {
            VisibilityZones vz = new VisibilityZones((SensorNode)this);
            vz.run();
        }
    }

    public void toOri() {
        this.longitude = this.longitude_ori;
        this.latitude = this.latitude_ori;
        this.elevation = this.elevation_ori;
        this.gpsFileName = this.gpsFileName_ori;
        if (SimulationInputs.visibility && (this.getType() == 1 || this.getType() == 5 || this.getType() == 4)) {
            VisibilityZones vz = new VisibilityZones((SensorNode)this);
            vz.run();
        }
    }

    public int getHide() {
        return this.hide;
    }

    public int getPic() {
        return this.pic;
    }

    @Override
    public void setPic(int pic) {
        this.pic = pic;
    }

    public abstract String startingName();

    public abstract double getNextTime();

    public abstract void loadRouteFromFile();

    public abstract void moveToNext(boolean var1, int var2);

    public abstract boolean hasNext();

    public abstract double getNextValueTime();

    public abstract void generateNextValue();

    public void setLedColor(int ledColor) {
        this.ledColor = ledColor;
    }

    public int getLedColor() {
        return this.ledColor;
    }

    public void setTrgetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String toString() {
        return "" + this.id;
    }

    public void creatValueList() {
        this.valueList = new LinkedList();
    }

    public Double getIthValue(int i) {
        return this.valueList.get(i);
    }

    public void addValue(Double value) {
        this.valueList.add(value);
    }

    public void removeValue(Double value) {
        this.valueList.remove(value);
    }

    public void removeIthValue(int i) {
        this.valueList.remove(i);
    }

    public SenScript getScript() {
        return this.script;
    }

    public void setEvent(double event) {
        this.event = event;
    }

    public void setEvent(String event) {
        this.event = Double.parseDouble(event);
    }

    public double getEvent() {
        return this.event;
    }

    public void setEvent2(double event) {
        this.event2 = event;
    }

    public double getEvent2() {
        return this.event2;
    }

    public void setEvent3(double event) {
        this.event3 = event;
    }

    public double getEvent3() {
        return this.event3;
    }

    public abstract void loadScript();

    public abstract void initBuffer();

    public abstract void initForSimulation();

    public Device cloneWithSameId() throws CloneNotSupportedException {
        Device newNode = (Device)super.clone();
        newNode.setScriptFileName(this.scriptFileName);
        newNode.setGPSFileName(this.gpsFileName);
        return newNode;
    }

    public Device cloneDeviceWithId() throws CloneNotSupportedException {
        Device newNode = (Device)super.clone();
        newNode.setScriptFileName(this.scriptFileName);
        newNode.setGPSFileName(this.gpsFileName);
        return newNode;
    }

    public void init() {
        this.message = "";
        this.setMarked(false);
        this.setVisited(false);
        this.setDead(false);
        this.setLedColor(0);
        this.initBattery();
        this.initBuffer();
    }

    public abstract void initBattery();

    public boolean isSending() {
        return this.sending;
    }

    public boolean isWriting() {
        return this.writing;
    }

    public boolean isReceiving() {
        return this.receiving;
    }

    public void setSending(boolean b) {
        this.sending = b;
    }

    public void setWriting(boolean b) {
        this.writing = b;
    }

    public void setReceiving(boolean b) {
        this.receiving = b;
    }

    public Color getRadioLinkColor() {
        return this.radioLinkColor;
    }

    public void setRadioLinkColor(Color radioLinkColor) {
        this.radioLinkColor = radioLinkColor;
    }

    public void gotoTheNextInstruction() {
        if (!this.script.getCurrent().isExecuting()) {
            this.script.next();
        }
    }

    public void gotoTheNextEvent(double min) {
        if (this.event != Double.MAX_VALUE) {
            this.event -= min;
        }
    }

    public long getDistanceModeDelay() {
        return this.distanceModeDelay;
    }

    public void setDistanceModeDelay(long distanceModeDelay) {
        this.distanceModeDelay = distanceModeDelay;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public long getUartDataRate() {
        return this.uartDataRate;
    }

    public void setUartDataRate(long uartDataRate) {
        this.uartDataRate = uartDataRate;
    }

    public void drift() {
        double d = this.random.nextGaussian() * this.sigmaOfDriftTime;
        if (d > 3.0 * this.sigmaOfDriftTime) {
            d = 3.0 * this.sigmaOfDriftTime;
        }
        if (d < -3.0 * this.sigmaOfDriftTime) {
            d = -3.0 * this.sigmaOfDriftTime;
        }
        System.out.println(d);
        this.driftTime = 1.0 - d;
    }

    public double getDriftTime() {
        return this.driftTime;
    }

    public double getSigmaOfDriftTime() {
        return this.sigmaOfDriftTime;
    }

    public abstract Polygon getRadioPolygon();

    public abstract int execute();

    public abstract void drawRadioLinks(Graphics var1, int var2);

    public abstract void calculatePropagations();

    public abstract void resetPropagations();

    public abstract void drawRadioPropagations(Graphics var1);

    public abstract boolean radioDetect(DeviceWithRadio var1);

    public void setSigmaOfDriftTime(double sigmaOfDriftTime) {
        this.sigmaOfDriftTime = sigmaOfDriftTime;
    }

    public boolean isMobile() {
        return !this.gpsFileName.equals("");
    }

    public boolean getDisplaydRadius() {
        return this.displayRadius;
    }

    public void setDisplaydRadius(boolean b) {
        this.displayRadius = b;
    }

    public boolean getDisplaydInfos() {
        return this.displayInfos;
    }

    public void setDisplaydInfos(boolean b) {
        this.displayInfos = b;
    }

    public void setHide(int hide) {
        this.hide = hide;
    }

    public boolean getDrawBatteryLevel() {
        return this.drawBatteryLevel;
    }

    public void setDrawBatteryLevel(boolean b) {
        this.drawBatteryLevel = b;
    }

    public void drawId(int x, int y, Graphics g) {
        if (NetworkParameters.displayDetails) {
            g.setColor(Color.BLACK);
            if (MapLayer.dark) {
                g.setColor(new Color(179, 221, 67));
            }
            g.drawString(this.getName(), x + 10, y + 6);
        }
    }

    public void increaseRadius(int d) {
        this.radius += (double)d;
    }

    public abstract double getSensorUnitRadius();

    public abstract double getESensing();

    public void invertDrawBatteryLevel() {
        this.drawBatteryLevel = !this.drawBatteryLevel;
    }

    public abstract Device duplicate();

    public abstract Device duplicateWithShift(double var1, double var3, double var5);

    public abstract void save(String var1);

    public double getSUCoverage() {
        return 0.0;
    }

    public double getSUDirection() {
        return 0.0;
    }

    public void setAction() {
        this.action = true;
    }

    public boolean getAction() {
        boolean rAction = this.action;
        this.action = false;
        return rAction;
    }
}

