/*
 * Decompiled with CFR 0.152.
 */
package device;

import device.Device;
import device.DeviceList;
import device.DeviceWithRadio;
import device.LocationEvent;
import device.MapObject;
import device.SensorNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import map.MapLayer;
import markers.Marker;
import markers.MarkerList;
import project.Project;
import simulation.SimulationInputs;
import visibility.VisibilityZones;

public abstract class DeviceWithWithoutRadio
extends Device {
    protected double speedRatio = 1.0;
    protected double routeDx = 0.0;
    protected double routeDy = 0.0;
    protected LinkedList<Integer> routeTime;
    protected LinkedList<Double> routeX;
    protected LinkedList<Double> routeY;
    protected LinkedList<Double> routeZ;
    protected boolean loop = false;
    protected int nLoop = 0;
    protected int routeIndex = 0;
    protected ArrayList<LocationEvent> locEvents = new ArrayList();

    public DeviceWithWithoutRadio() {
    }

    public DeviceWithWithoutRadio(double x, double y, double z, double radius, int id) {
        super(x, y, z, radius, id);
    }

    @Override
    public void loadRouteFromFile() {
        this.loadRouteFromFile(this.gpsFileName);
    }

    public int getRouteSize() {
        return this.routeTime.size();
    }

    public int getIthWTime(int i) {
        return this.routeTime.get(i);
    }

    public double getIthX(int i) {
        return this.routeX.get(i);
    }

    public double getIthY(int i) {
        return this.routeY.get(i);
    }

    public double getIthZ(int i) {
        return this.routeZ.get(i);
    }

    public void loadRouteFromFile(String fileName) {
        try {
            if (!fileName.isEmpty()) {
                String s;
                this.routeTime = new LinkedList();
                this.routeX = new LinkedList();
                this.routeY = new LinkedList();
                this.routeZ = new LinkedList();
                BufferedReader b = null;
                FileInputStream fis = new FileInputStream(Project.getProjectGpsPath() + File.separator + fileName);
                b = new BufferedReader(new InputStreamReader(fis));
                this.underSimulation = true;
                b.readLine();
                b.readLine();
                b.readLine();
                this.loop = Boolean.parseBoolean(b.readLine());
                this.nLoop = Integer.parseInt(b.readLine());
                while ((s = b.readLine()) != null) {
                    String[] ts = s.split(" ");
                    this.routeTime.add(Integer.parseInt(ts[0]));
                    this.routeX.add(Double.parseDouble(ts[1]));
                    this.routeY.add(Double.parseDouble(ts[2]));
                    this.routeZ.add(Double.parseDouble(ts[3]));
                }
                b.close();
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadRouteFrom2Files(int idx1_f, String fileName2, int idx2) {
        String fileName1 = this.getGPSFileName();
        int[] t = new int[this.routeTime.size()];
        double[] tx = new double[this.routeTime.size()];
        double[] ty = new double[this.routeTime.size()];
        double[] tz = new double[this.routeTime.size()];
        for (int i = 0; i < this.routeTime.size(); ++i) {
            t[i] = this.routeTime.get(i);
            tx[i] = this.routeX.get(i);
            ty[i] = this.routeY.get(i);
            tz[i] = this.routeZ.get(i);
        }
        try {
            if (!fileName1.equals("") && !fileName2.equals("")) {
                String s;
                int i;
                this.routeTime = new LinkedList();
                this.routeX = new LinkedList();
                this.routeY = new LinkedList();
                this.routeZ = new LinkedList();
                BufferedReader b = null;
                this.underSimulation = true;
                this.loop = false;
                this.nLoop = 1;
                for (i = this.routeIndex; i < idx1_f; ++i) {
                    this.routeTime.add(t[i]);
                    this.routeX.add(tx[i]);
                    this.routeY.add(ty[i]);
                    this.routeZ.add(tz[i]);
                }
                FileInputStream fis = new FileInputStream(Project.getProjectGpsPath() + File.separator + fileName2);
                b = new BufferedReader(new InputStreamReader(fis));
                b.readLine();
                b.readLine();
                b.readLine();
                b.readLine();
                b.readLine();
                i = 0;
                while ((s = b.readLine()) != null) {
                    if (i >= idx2) {
                        String[] ts = s.split(" ");
                        this.routeTime.add(Integer.parseInt(ts[0]));
                        this.routeX.add(Double.parseDouble(ts[1]));
                        this.routeY.add(Double.parseDouble(ts[2]));
                        this.routeZ.add(Double.parseDouble(ts[3]));
                    }
                    ++i;
                }
                b.close();
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void preprocessing() {
        this.routeIndex = 0;
    }

    @Override
    public void initForSimulation() {
        this.loadRouteFromFile();
        this.fixori();
        this.routeIndex = 0;
        this.locEvents = new ArrayList();
    }

    public void runSimulation() {
        if (!this.gpsFileName.isEmpty()) {
            this.loadRouteFromFile();
            this.fixori();
            this.underSimulation = true;
            this.routeIndex = 0;
            long tmpTime = 0L;
            long cTime = 0L;
            long toWait = 0L;
            do {
                cTime = this.routeTime.get(this.routeIndex).intValue();
                toWait = cTime - tmpTime;
                tmpTime = cTime;
                if (toWait < 0L) {
                    toWait = cTime;
                }
                this.longitude = this.routeX.get(this.routeIndex);
                this.latitude = this.routeY.get(this.routeIndex);
                this.elevation = this.routeZ.get(this.routeIndex);
                if (DeviceList.propagationsCalculated) {
                    DeviceList.calculatePropagations();
                }
                MapLayer.repaint();
                try {
                    Thread.sleep(toWait * (long)Device.moveSpeed);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.goToNext();
            } while (this.hasNext());
            try {
                Thread.sleep(toWait * (long)Device.moveSpeed);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.routeIndex = 0;
            this.toOri();
            this.thread = null;
            this.underSimulation = false;
            MapLayer.repaint();
        }
    }

    @Override
    public void run() {
        this.runSimulation();
    }

    @Override
    public double getNextTime() {
        if (this.routeTime.size() > 0) {
            return this.routeTime.get(this.routeIndex).intValue();
        }
        return 0.0;
    }

    @Override
    public void moveToNext(boolean visual, int visualDelay) {
        if (!this.gpsFileName.isEmpty()) {
            if (this.routeTime != null && this.nLoop > 0) {
                this.longitude = this.routeX.get(this.routeIndex) + this.routeDx;
                this.latitude = this.routeY.get(this.routeIndex) + this.routeDy;
                this.elevation = this.routeZ.get(this.routeIndex);
                if (SimulationInputs.visibility && (this.getType() == 1 || this.getType() == 5 || this.getType() == 4)) {
                    VisibilityZones vz = new VisibilityZones((SensorNode)this);
                    vz.run();
                }
                ++this.routeIndex;
                if (this.routeIndex >= this.routeTime.size()) {
                    --this.nLoop;
                    this.routeIndex = !this.loop || this.nLoop == 0 ? --this.routeIndex : 1;
                }
                if (DeviceList.propagationsCalculated) {
                    DeviceList.calculatePropagations();
                }
            }
            if (visual) {
                try {
                    MapLayer.repaint();
                    Thread.sleep(visualDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void goToNext() {
        if (!this.gpsFileName.isEmpty() && this.routeTime != null) {
            ++this.routeIndex;
            if (this.routeIndex == this.routeTime.size() && this.loop) {
                --this.nLoop;
                this.routeIndex = 0;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nLoop == 0 && this.loop) {
            return false;
        }
        return this.routeIndex < this.routeTime.size();
    }

    public LinkedList<Integer> getRouteTime() {
        return this.routeTime;
    }

    public void setRouteTime(LinkedList<Integer> routeTime) {
        this.routeTime = routeTime;
    }

    public LinkedList<Double> getRouteX() {
        return this.routeX;
    }

    public void setRouteX(LinkedList<Double> routeX) {
        this.routeX = routeX;
    }

    public LinkedList<Double> getRouteY() {
        return this.routeY;
    }

    public void setRouteY(LinkedList<Double> routeY) {
        this.routeY = routeY;
    }

    @Override
    public boolean radioDetect(DeviceWithRadio device) {
        return false;
    }

    public void setRoute(String name) {
        this.gpsFileName = name + ".gps";
    }

    public String getRoute() {
        return this.gpsFileName;
    }

    public void setRouteIndex(int index) {
        this.routeIndex = index;
    }

    public int getRouteIndex() {
        return this.routeIndex;
    }

    public void initLocEvents() {
        this.locEvents = new ArrayList();
    }

    public void addLocEvent(double time, double longitude, double latitude, double elevation) {
        this.locEvents.add(new LocationEvent(time, longitude, latitude, elevation));
    }

    public void executeLocEvent() {
        if (this.locEvents != null && this.locEvents.size() > 0 && this.locEvents.get(0).getTime() == 0.0) {
            this.setLatitude(this.locEvents.get(0).getLatitude());
            this.setLongitude(this.locEvents.get(0).getLongitude());
            this.setElevation(this.locEvents.get(0).getElevation());
            this.locEvents.remove(0);
            if (SimulationInputs.visibility) {
                VisibilityZones vz = new VisibilityZones((SensorNode)this);
                vz.run();
            }
            if (DeviceList.propagationsCalculated) {
                DeviceList.calculatePropagations();
            }
        }
    }

    public void goToNextLocEvent(double time) {
        if (this.locEvents != null && this.locEvents.size() > 0) {
            this.locEvents.get(0).setTime(this.locEvents.get(0).getTime() - time);
        }
    }

    public double getLocEventTime() {
        if (this.locEvents != null && this.locEvents.size() > 0) {
            return this.locEvents.get(0).getTime();
        }
        return Double.MAX_VALUE;
    }

    public void displayLocs() {
        for (LocationEvent ev : this.locEvents) {
            System.out.println(ev);
        }
    }

    public void routeToObject(MapObject object) {
        MarkerList.reset();
        MarkerList.add(new Marker(this.getLongitude(), this.getLatitude(), 0.0, 4.0));
        MarkerList.add(new Marker(object.getLongitude(), object.getLatitude(), 0.0, 4.0));
        MarkerList.generateOSMRouteFile();
    }

    public void routeToNearestEV() {
        Device nearestDevice = null;
        int min = Integer.MAX_VALUE;
        for (Device device : DeviceList.devices) {
            if (device.getId() == this.getId()) continue;
            device.unmark();
            MarkerList.reset();
            MarkerList.add(new Marker(this.getLongitude(), this.getLatitude(), 0.0, 4.0));
            MarkerList.add(new Marker(device.getLongitude(), device.getLatitude(), 0.0, 4.0));
            MarkerList.generateOSMRouteFile();
            MarkerList.markers.size();
            if (MarkerList.markers.size() >= min) continue;
            min = MarkerList.markers.size();
            nearestDevice = device;
        }
        MarkerList.reset();
        MarkerList.generateOSMRouteFile();
        nearestDevice.mark();
    }

    public double getRouteDx() {
        return this.routeDx;
    }

    public void setRouteDx(double routeDx) {
        this.routeDx = routeDx;
    }

    public double getRouteDy() {
        return this.routeDy;
    }

    public void setRouteDy(double routeDy) {
        this.routeDy = routeDy;
    }

    public double getSpeedRatio() {
        return this.speedRatio;
    }

    public void setSpeedRatio(double speedRatio) {
        this.speedRatio = speedRatio;
    }
}

