/*
 * Decompiled with CFR 0.152.
 */
package device;

import device.MessageEvent;
import device.SensorNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import map.MapLayer;
import map.NetworkParameters;
import radio_module.ErrorBits;
import radio_module.RadioPacketGenerator;
import simulation.SimulationInputs;
import simulation.WisenSimulation;
import utilities.MapCalc;

public class MessageEventList {
    public static double numberOfSentMessages = 0.0;
    public static double numberOfReceivedMessages = 0.0;
    public static double numberOfAckMessages = 0.0;
    public static double numberOfLostMessages = 0.0;
    public static double numberOfSentMessages_b = 0.0;
    public static double numberOfReceivedMessages_b = 0.0;
    public static double numberOfAckMessages_b = 0.0;
    public static double numberOfLostMessages_b = 0.0;
    protected List<List<MessageEvent>> messageEventLists = Collections.synchronizedList(new LinkedList());

    public MessageEventList(int std) {
        this.init(std);
    }

    public static void reset() {
        numberOfSentMessages = 0.0;
        numberOfReceivedMessages = 0.0;
        numberOfAckMessages = 0.0;
        numberOfLostMessages = 0.0;
        numberOfSentMessages_b = 0.0;
        numberOfReceivedMessages_b = 0.0;
        numberOfAckMessages_b = 0.0;
        numberOfLostMessages_b = 0.0;
    }

    public void init(int std) {
        this.messageEventLists.removeAll(this.messageEventLists);
        int channelNumber = 0;
        if (std == 1) {
            channelNumber = 16;
        }
        if (std == 3) {
            channelNumber = 1;
        }
        if (std == 2) {
            channelNumber = 14;
        }
        for (int i = 0; i < channelNumber; ++i) {
            this.messageEventLists.add(new LinkedList());
        }
    }

    public void addMessageEvent(int type, String message, SensorNode tSensor, SensorNode rSensor) {
        if (!rSensor.isReceiving() || !SimulationInputs.ack || type == 1) {
            if (type == 1) {
                numberOfAckMessages += tSensor.getPl() / 100.0;
                numberOfAckMessages_b += (double)message.length() * (tSensor.getPl() / 100.0);
            }
            WisenSimulation.simLog.add("S" + rSensor.getId() + " (radio: " + rSensor.getCurrentRadioModule().getName() + ") is receiving the message : \"" + message + "\" in its buffer.");
            double ratio1 = 1.0 / (double)tSensor.getCurrentRadioModule().getRadioDataRate();
            double ratio2 = 1.0 / (double)rSensor.getUartDataRate();
            double durationOfSending = ratio1 * (double)RadioPacketGenerator.packetLengthInBits(message, type, tSensor.getStandard());
            double durationOfUARTReceiving = 0.0;
            durationOfUARTReceiving = type == 1 ? 0.0 : ratio2 * (double)(message.length() * 8);
            double duration = durationOfSending + durationOfUARTReceiving;
            double lastTime = 0.0;
            tSensor.setSending(true);
            rSensor.setReceiving(true);
            MessageEvent messageEvent = new MessageEvent(type, tSensor, rSensor, message, lastTime + duration);
            this.messageEventLists.get(tSensor.getCurrentRadioModule().getCh()).add(messageEvent);
        }
    }

    public void receivedMessages() {
        for (List<MessageEvent> messageEventList : this.messageEventLists) {
            while (messageEventList.size() > 0 && messageEventList.get(0).getTime() == 0.0) {
                int type = messageEventList.get(0).getType();
                String message = messageEventList.get(0).getMessage();
                SensorNode tSensor = messageEventList.get(0).getSSensor();
                SensorNode rSensor = messageEventList.get(0).getRSensor();
                rSensor.setDrssi(tSensor.distance(rSensor));
                numberOfReceivedMessages += tSensor.getPl() / 100.0;
                numberOfReceivedMessages_b += (double)message.length() * (tSensor.getPl() / 100.0);
                rSensor.consumeRx(RadioPacketGenerator.packetLengthInBits(message, type, tSensor.getStandard()));
                boolean errorBitsOk = ErrorBits.errorBitsOk(message, tSensor, rSensor);
                tSensor.setSending(false);
                rSensor.setReceiving(false);
                if (!(type != 0 && type != 2 || !errorBitsOk && type != 2)) {
                    rSensor.addMessageToBuffer(messageEventList.get(0).getMessage());
                    if (rSensor.getScript().getCurrent().isWait()) {
                        rSensor.setEvent(0.0);
                    }
                    if (type == 0 && SimulationInputs.ack) {
                        this.addMessageEvent(1, "", rSensor, tSensor);
                    }
                }
                if (type == 1) {
                    tSensor.setAckWaiting(false);
                    rSensor.setAckReceived(true);
                    rSensor.setAckWaiting(false);
                    rSensor.setEvent(0.0);
                }
                messageEventList.remove(0);
            }
        }
    }

    public void goToTheNextTime(double min) {
        for (List<MessageEvent> massageEventList : this.messageEventLists) {
            for (MessageEvent messageEvent : massageEventList) {
                messageEvent.setTime(messageEvent.getTime() - min);
            }
        }
    }

    public double getMin() {
        double min = Double.MAX_VALUE;
        for (List<MessageEvent> messageEventList : this.messageEventLists) {
            if (messageEventList.size() <= 0 || !(messageEventList.get(0).getTime() < min)) continue;
            min = messageEventList.get(0).getTime();
        }
        return min;
    }

    public void drawChannelLinks(Graphics g) {
        for (List<MessageEvent> messageEventList : this.messageEventLists) {
            if (messageEventList.size() <= 0) continue;
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(new BasicStroke(2.0f));
            if (MapLayer.mapViewer.getZoom() > 3) {
                g2.setStroke(new BasicStroke(1.0f));
            }
            if (MapLayer.mapViewer.getZoom() < 2) {
                g2.setStroke(new BasicStroke(3.0f));
            }
            double dx = 0.0;
            double dy = 0.0;
            double alpha = 0.0;
            for (int idx = 0; idx < messageEventList.size(); ++idx) {
                try {
                    MessageEvent messageEvent = messageEventList.get(idx);
                    if (!messageEvent.getSSensor().isSending() || !messageEvent.getRSensor().isReceiving() || messageEvent.getType() != 0 && messageEvent.getType() != 2 && (messageEvent.getType() != 1 || !SimulationInputs.showAckLinks)) continue;
                    g.setColor(messageEvent.getSSensor().getRadioLinkColor());
                    if (messageEvent.getType() == 1 && SimulationInputs.showAckLinks) {
                        g.setColor(Color.BLACK);
                        if (MapLayer.dark) {
                            g.setColor(Color.ORANGE);
                        }
                    }
                    int[] coord = MapCalc.geoToPixelMapA(messageEvent.getSSensor().getLatitude(), messageEvent.getSSensor().getLongitude());
                    int lx1 = coord[0];
                    int ly1 = coord[1];
                    coord = MapCalc.geoToPixelMapA(messageEvent.getRSensor().getLatitude(), messageEvent.getRSensor().getLongitude());
                    int lx2 = coord[0];
                    int ly2 = coord[1];
                    dx = lx2 - lx1;
                    dy = ly2 - ly1;
                    g.drawLine(lx1, ly1, lx2, ly2);
                    alpha = Math.atan(dy / dx);
                    alpha = 180.0 * alpha / Math.PI;
                    int as = 14;
                    if (MapLayer.mapViewer.getZoom() < 2) {
                        as = 21;
                    }
                    if (MapLayer.mapViewer.getZoom() > 3) {
                        as = 10;
                    }
                    if (dx >= 0.0) {
                        g.fillArc(lx2 - as, ly2 - as, as * 2, as * 2, 180 - (int)alpha - as, as * 2);
                    } else {
                        g.fillArc(lx2 - as, ly2 - as, as * 2, as * 2, -((int)alpha) - as, as * 2);
                    }
                    if (!NetworkParameters.displayRadioMessages || messageEvent.getType() == 1) continue;
                    MapLayer.drawMessage(lx1, lx2, ly1, ly2, messageEvent.getMessage(), g2);
                    MapLayer.drawMessageAttempts(lx1, lx2, ly1, ly2, "" + (messageEvent.getSSensor().getAttempts() + 1), g2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void display() {
        Object s = "";
        for (List<MessageEvent> messageEventList : this.messageEventLists) {
            s = (String)s + "[";
            for (MessageEvent messageEvent : messageEventList) {
                s = (String)s + messageEvent.toString() + " | ";
            }
            s = (String)s + "]\n";
        }
        System.out.println((String)s);
    }
}

