/*
 * Decompiled with CFR 0.152.
 */
package device;

import device.MessageEventList;
import device.SensorNode;
import java.awt.Graphics;
import java.util.LinkedList;

public class MultiChannels {
    public static LinkedList<MessageEventList> channelList = new LinkedList();

    public MultiChannels() {
        MultiChannels.init();
    }

    public static void init() {
        channelList.removeAll(channelList);
        channelList.add(new MessageEventList(1));
        channelList.add(new MessageEventList(2));
        channelList.add(new MessageEventList(3));
    }

    public static void addChannel(int std) {
        MessageEventList channel = new MessageEventList(std);
        channelList.add(channel);
    }

    public static void addPacketEvent(int type, String message, SensorNode sSensor, SensorNode rSensor) {
        int stdR;
        int stdS = sSensor.getStandard();
        if (stdS == (stdR = rSensor.getStandard())) {
            channelList.get(stdS - 1).addMessageEvent(type, message, sSensor, rSensor);
        }
    }

    public static void receivedMessages() {
        for (MessageEventList channel : channelList) {
            channel.receivedMessages();
        }
    }

    public static void goToTheNextTime(double min) {
        for (MessageEventList channel : channelList) {
            channel.goToTheNextTime(min);
        }
    }

    public static double getMin() {
        double min = Double.MAX_VALUE;
        for (MessageEventList channel : channelList) {
            if (channel == null || !(channel.getMin() < min)) continue;
            min = channel.getMin();
        }
        return min;
    }

    public static void drawChannelLinks(Graphics g) {
        for (MessageEventList channel : channelList) {
            channel.drawChannelLinks(g);
        }
    }
}

