/*
 * Decompiled with CFR 0.152.
 */
package interference;

import interference.AlphaStableRandom;
import math.Complex;
import math.FFT;

public class WiFiTransceiver {
    public static double getNumberOfReceivedErrorBits(String inputMsg, int noNeghboringNodes, int radioRange, int perActiveNodes) {
        double errBits = 0.0;
        int signalConstellation = 16;
        int symbolSize = signalConstellation / 4;
        int subChannels = 64;
        int cp = 2;
        int sizeout = subChannels * 2 + cp;
        byte[] binaryData = WiFiTransceiver.getStringToBinary(inputMsg);
        byte[] binarySource = new byte[subChannels * symbolSize * 2];
        if (binaryData.length >= subChannels * symbolSize * 2) {
            System.out.print("Too Long Message");
        } else {
            for (int i = 0; i < subChannels * symbolSize * 2; ++i) {
                binarySource[i] = i < binaryData.length ? binaryData[i] : (byte)0;
            }
            int lengthDecNo = binarySource.length / symbolSize;
            int[] DecNumbers = new int[lengthDecNo];
            int j = 0;
            for (int i = 0; i < binarySource.length; i += 4) {
                String s = "" + binarySource[i] + binarySource[i + 1] + binarySource[i + 2] + binarySource[i + 3];
                DecNumbers[j] = Integer.parseInt(s, 2);
                ++j;
            }
            Complex[] qMapping = new Complex[]{new Complex(-3.0, -3.0), new Complex(-3.0, -1.0), new Complex(-3.0, 3.0), new Complex(-3.0, 1.0), new Complex(-1.0, -3.0), new Complex(-1.0, -1.0), new Complex(-1.0, 3.0), new Complex(-1.0, 1.0), new Complex(3.0, -3.0), new Complex(3.0, -1.0), new Complex(3.0, 3.0), new Complex(3.0, 1.0), new Complex(1.0, -3.0), new Complex(1.0, -1.0), new Complex(1.0, 3.0), new Complex(1.0, 1.0)};
            Complex[] modulatedSource = new Complex[lengthDecNo];
            for (int i = 0; i < lengthDecNo; ++i) {
                modulatedSource[i] = qMapping[DecNumbers[i]];
            }
            Complex[] IFFTsource = FFT.ifft(modulatedSource, subChannels * 2);
            Complex[] cyclicPrefixedSource = new Complex[IFFTsource.length + cp];
            for (int i = 0; i < IFFTsource.length; ++i) {
                cyclicPrefixedSource[i + cp] = IFFTsource[i];
            }
            cyclicPrefixedSource[0] = IFFTsource[IFFTsource.length - 2];
            cyclicPrefixedSource[1] = IFFTsource[IFFTsource.length - 1];
            double[] alpharnd1 = AlphaStableRandom.generateNext(noNeghboringNodes, radioRange, perActiveNodes, sizeout);
            double[] alpharnd2 = AlphaStableRandom.generateNext(noNeghboringNodes, radioRange, perActiveNodes, sizeout);
            Complex[] alpharnd = new Complex[sizeout];
            for (int i = 0; i < sizeout; ++i) {
                alpharnd[i] = new Complex(alpharnd1[i], alpharnd2[i]);
            }
            Complex[] rx = new Complex[sizeout];
            double[] noise_real = new double[sizeout];
            double[] noise_imag = new double[sizeout];
            for (int i = 0; i < sizeout; ++i) {
                noise_real[i] = cyclicPrefixedSource[i].re() + alpharnd[i].re();
                noise_imag[i] = cyclicPrefixedSource[i].im() + alpharnd[i].im();
                rx[i] = new Complex(noise_real[i], noise_imag[i]);
            }
            Complex[] rx_rcp = new Complex[rx.length - cp];
            for (int i = 0; i < IFFTsource.length; ++i) {
                rx_rcp[i] = rx[i + cp];
            }
            Complex[] FFTsignal = FFT.fft(rx_rcp, subChannels * 2);
            int[] deModulatedSignal = new int[FFTsignal.length];
            for (int i = 0; i < FFTsignal.length; ++i) {
                for (int h = 0; h < qMapping.length; ++h) {
                    if (Math.round(FFTsignal[i].im()) != Math.round(qMapping[h].im()) || Math.round(FFTsignal[i].re()) != Math.round(qMapping[h].re())) continue;
                    deModulatedSignal[i] = h;
                }
            }
            String[] qDeMapping = new String[deModulatedSignal.length * 4];
            block27: for (int i = 0; i < deModulatedSignal.length; ++i) {
                switch (deModulatedSignal[i]) {
                    case 0: {
                        deModulatedSignal[i] = 0;
                        qDeMapping[i] = "0000";
                        continue block27;
                    }
                    case 1: {
                        deModulatedSignal[i] = 1;
                        qDeMapping[i] = "0001";
                        continue block27;
                    }
                    case 2: {
                        deModulatedSignal[i] = 2;
                        qDeMapping[i] = "0010";
                        continue block27;
                    }
                    case 3: {
                        deModulatedSignal[i] = 3;
                        qDeMapping[i] = "0011";
                        continue block27;
                    }
                    case 4: {
                        deModulatedSignal[i] = 4;
                        qDeMapping[i] = "0100";
                        continue block27;
                    }
                    case 5: {
                        deModulatedSignal[i] = 5;
                        qDeMapping[i] = "0101";
                        continue block27;
                    }
                    case 6: {
                        deModulatedSignal[i] = 6;
                        qDeMapping[i] = "0110";
                        continue block27;
                    }
                    case 7: {
                        deModulatedSignal[i] = 7;
                        qDeMapping[i] = "0111";
                        continue block27;
                    }
                    case 8: {
                        deModulatedSignal[i] = 8;
                        qDeMapping[i] = "1000";
                        continue block27;
                    }
                    case 9: {
                        deModulatedSignal[i] = 9;
                        qDeMapping[i] = "1001";
                        continue block27;
                    }
                    case 10: {
                        deModulatedSignal[i] = 10;
                        qDeMapping[i] = "1010";
                        continue block27;
                    }
                    case 11: {
                        deModulatedSignal[i] = 11;
                        qDeMapping[i] = "1011";
                        continue block27;
                    }
                    case 12: {
                        deModulatedSignal[i] = 12;
                        qDeMapping[i] = "1100";
                        continue block27;
                    }
                    case 13: {
                        deModulatedSignal[i] = 13;
                        qDeMapping[i] = "1101";
                        continue block27;
                    }
                    case 14: {
                        deModulatedSignal[i] = 14;
                        qDeMapping[i] = "1110";
                        continue block27;
                    }
                    case 15: {
                        deModulatedSignal[i] = 15;
                        qDeMapping[i] = "1111";
                    }
                }
            }
            byte[] decimalToBin = new byte[deModulatedSignal.length * 4];
            for (int i = 0; i < deModulatedSignal.length * 4; ++i) {
                decimalToBin[i] = WiFiTransceiver.getNthBit(qDeMapping, i);
            }
            byte[] cb = new byte[decimalToBin.length];
            for (int i = 0; i < decimalToBin.length; ++i) {
                cb[i] = binarySource[i];
                errBits += cb[i] == decimalToBin[i] ? 0.0 : 1.0;
            }
        }
        return errBits;
    }

    public static byte getNthBit(String[] t, int n) {
        byte bit = (byte)Integer.parseInt("" + t[n / 4].charAt(n % 4));
        return bit;
    }

    static double logGamma(double x) {
        double tmp = (x - 0.5) * Math.log(x + 4.5) - (x + 4.5);
        double ser = 1.0 + 76.18009173 / (x + 0.0) - 86.50532033 / (x + 1.0) + 24.01409822 / (x + 2.0) - 1.231739516 / (x + 3.0) + 0.00120858003 / (x + 4.0) - 5.36382E-6 / (x + 5.0);
        return tmp + Math.log(ser * Math.sqrt(Math.PI * 2));
    }

    static double gamma(double x) {
        return Math.exp(WiFiTransceiver.logGamma(x));
    }

    public static byte[] getStringToBinary(String inputMsg) {
        Object s2 = "";
        for (int i = 0; i < inputMsg.length(); ++i) {
            char c = inputMsg.charAt(i);
            s2 = (String)s2 + String.format("%8s", Integer.toBinaryString(c)).replaceAll(" ", "0");
        }
        s2 = ((String)s2).replaceAll("0", "\u0000");
        s2 = ((String)s2).replaceAll("1", "\u0001");
        byte[] binarySource = ((String)s2).getBytes();
        return binarySource;
    }
}

