/*
 * Decompiled with CFR 0.152.
 */
package markers;

import device.DeviceList;
import device.MapObject;
import device.StdSensorNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import map.MapLayer;
import markers.MarkerList;
import utilities.MapCalc;
import utilities.UColor;

public class Marker
extends MapObject {
    private static String idFL = "U";

    public Marker(double x, double y, double z, double radius) {
        super(x, y, z, radius, 0);
    }

    public Marker(String x, String y, String z, String radius) {
        super(Double.valueOf(x), Double.valueOf(y), Double.valueOf(z), Double.valueOf(radius), 0);
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(new BasicStroke(0.5f));
        if (this.visible) {
            this.initDraw(g);
            int[] coord = MapCalc.geoToPixelMapA(this.latitude, this.longitude);
            int x = coord[0];
            int y = coord[1];
            int rayon = MapCalc.radiusInPixels(this.radius);
            if (this.inside || this.selected) {
                g.setColor(Color.GRAY);
                if (MapLayer.dark) {
                    g.setColor(Color.LIGHT_GRAY);
                }
                g.drawLine(x - rayon - 3, y - rayon - 3, x - rayon + 2, y - rayon - 3);
                g.drawLine(x - rayon - 3, y - rayon - 3, x - rayon - 3, y - rayon + 2);
                g.drawLine(x - rayon - 3, y + rayon + 3, x - rayon + 2, y + rayon + 3);
                g.drawLine(x - rayon - 3, y + rayon + 3, x - rayon - 3, y + rayon - 2);
                g.drawLine(x + rayon + 3, y - rayon - 3, x + rayon - 2, y - rayon - 3);
                g.drawLine(x + rayon + 3, y - rayon - 3, x + rayon + 3, y - rayon + 2);
                g.drawLine(x + rayon + 3, y + rayon + 3, x + rayon - 2, y + rayon + 3);
                g.drawLine(x + rayon + 3, y + rayon + 3, x + rayon + 3, y + rayon - 2);
            }
            if (this.selected) {
                g.setColor(Color.GRAY);
                if (MapLayer.dark) {
                    g.setColor(Color.LIGHT_GRAY);
                }
                g.drawOval(x - rayon - 2, y - rayon - 2, (rayon + 2) * 2, (rayon + 2) * 2);
            }
            if (this.hide == 0) {
                g.setColor(UColor.BLUE);
                g.fillOval(x - 3, y - 3, 6, 6);
            }
        }
    }

    public static Marker getCentre(Marker marker1, Marker marker2, boolean b) {
        double x1 = marker1.getLongitude();
        double y1 = marker1.getLatitude();
        double z1 = marker1.getElevation();
        double x2 = marker2.getLongitude();
        double y2 = marker2.getLatitude();
        double z2 = marker2.getElevation();
        double x = x1 + (x2 - x1) / 2.0;
        double y = y1 + (y2 - y1) / 2.0;
        double z = z1 + (z2 - z1) / 2.0;
        Marker marker = new Marker(x, y, z, 4.0);
        marker.setSelected(b);
        return marker;
    }

    @Override
    public void run() {
        this.selected = false;
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public String getIdFL() {
        return idFL;
    }

    @Override
    public String getName() {
        return this.getIdFL() + this.id;
    }

    public void insertInAll() {
        int i = MarkerList.getIndex(this) + 1;
        if (i < MarkerList.size()) {
            MapLayer.addMarker(i, Marker.getCentre(this, MarkerList.get(i), true));
        }
    }

    public void insertAfterSelectedMarker() {
        int i;
        if (this.selected && (i = MarkerList.getIndex(this) + 1) < MarkerList.size()) {
            MapLayer.addMarker(i, Marker.getCentre(this, MarkerList.get(i), true));
        }
    }

    public void insertMarkerAndDeselect() {
        if (this.selected) {
            this.selected = false;
            int ix = MarkerList.getIndex(this) + 1;
            if (ix < MarkerList.size()) {
                MapLayer.addMarker(ix, Marker.getCentre(this, MarkerList.get(ix), true));
            }
        }
    }

    public void transformMarkerToSensor() {
        if (this.selected) {
            DeviceList.add(new StdSensorNode(this.longitude, this.latitude, this.elevation, 0.0, 100.0, -1));
        }
    }

    @Override
    public int getInsideRadius() {
        return 6;
    }

    public Marker cloneMarker() throws CloneNotSupportedException {
        Marker newNode = (Marker)super.clone();
        return newNode;
    }

    @Override
    public void initGeoZoneList() {
    }
}

