/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.MutableDynaClass;

public class LazyDynaMap
extends LazyDynaBean
implements MutableDynaClass {
    protected String name;
    protected boolean restricted;
    protected boolean returnNull = false;

    public LazyDynaMap() {
        this(null, (Map)null);
    }

    public LazyDynaMap(String name) {
        this(name, (Map)null);
    }

    public LazyDynaMap(Map values2) {
        this(null, values2);
    }

    public LazyDynaMap(String name, Map values2) {
        this.name = name == null ? "LazyDynaMap" : name;
        this.values = values2 == null ? this.newMap() : values2;
        this.dynaClass = this;
    }

    public LazyDynaMap(DynaProperty[] properties) {
        this(null, properties);
    }

    public LazyDynaMap(String name, DynaProperty[] properties) {
        this(name, (Map)null);
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                this.add(properties[i]);
                ++i;
            }
        }
    }

    public LazyDynaMap(DynaClass dynaClass) {
        this(dynaClass.getName(), dynaClass.getDynaProperties());
    }

    public void setMap(Map values2) {
        this.values = values2;
    }

    public void set(String name, Object value) {
        if (this.isRestricted() && !this.values.containsKey(name)) {
            throw new IllegalArgumentException("Invalid property name '" + name + "' (DynaClass is restricted)");
        }
        this.values.put(name, value);
    }

    public String getName() {
        return this.name;
    }

    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (!this.values.containsKey(name) && this.isReturnNull()) {
            return null;
        }
        Object value = this.values.get(name);
        if (value == null) {
            return new DynaProperty(name);
        }
        return new DynaProperty(name, value.getClass());
    }

    public DynaProperty[] getDynaProperties() {
        int i = 0;
        DynaProperty[] properties = new DynaProperty[this.values.size()];
        Iterator iterator2 = this.values.keySet().iterator();
        while (iterator2.hasNext()) {
            String name = (String)iterator2.next();
            Object value = this.values.get(name);
            properties[i++] = new DynaProperty(name, value == null ? null : value.getClass());
        }
        return properties;
    }

    public DynaBean newInstance() {
        return new LazyDynaMap(this);
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public void add(String name) {
        this.add(name, null);
    }

    public void add(String name, Class type) {
        if (name == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No new properties can be added.");
        }
        Object value = this.values.get(name);
        if (value == null) {
            this.values.put(name, type == null ? null : this.createProperty(name, type));
        }
    }

    public void add(String name, Class type, boolean readable, boolean writeable) {
        throw new UnsupportedOperationException("readable/writable properties not supported");
    }

    protected void add(DynaProperty property) {
        this.add(property.getName(), property.getType());
    }

    public void remove(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        if (this.isRestricted()) {
            throw new IllegalStateException("DynaClass is currently restricted. No properties can be removed.");
        }
        if (this.values.containsKey(name)) {
            this.values.remove(name);
        }
    }

    public boolean isReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(boolean returnNull) {
        this.returnNull = returnNull;
    }

    protected boolean isDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name is missing.");
        }
        return this.values.containsKey(name);
    }
}

