/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

public final class CharacterArrayConverter
extends AbstractArrayConverter {
    private static char[] model = new char[0];

    public CharacterArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public CharacterArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == value.getClass()) {
            return value;
        }
        if (AbstractArrayConverter.strings.getClass() == value.getClass()) {
            try {
                String[] values2 = (String[])value;
                char[] results = new char[values2.length];
                int i = 0;
                while (i < values2.length) {
                    results[i] = values2[i].charAt(0);
                    ++i;
                }
                return results;
            }
            catch (Exception e) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(value.toString(), e);
            }
        }
        try {
            List list = this.parseElements(value.toString());
            char[] results = new char[list.size()];
            int i = 0;
            while (i < results.length) {
                results[i] = ((String)list.get(i)).charAt(0);
                ++i;
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value.toString(), e);
        }
    }
}

