/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.jdesktop.http.HighSecurityX509TrustManager;
import org.jdesktop.http.LowSecurityX509TrustManager;
import org.jdesktop.http.MediumSecurityX509TrustManager;
import org.jdesktop.http.SecurityHandler;
import org.jdesktop.http.Session;

class SSLProtocolSocketFactory
implements SecureProtocolSocketFactory,
ProtocolSocketFactory {
    private SSLContext sslcontext = null;
    private SecurityHandler handler;
    private Session.SecurityLevel level;

    public SSLProtocolSocketFactory(SecurityHandler h, Session.SecurityLevel l) {
        this.handler = h;
        this.level = l;
    }

    private SSLContext getSSLContext(String host) {
        if (this.sslcontext == null) {
            try {
                X509TrustManager tm = null;
                tm = this.level == Session.SecurityLevel.Low ? new LowSecurityX509TrustManager(null) : (this.level == Session.SecurityLevel.Medium ? new MediumSecurityX509TrustManager(host, this.handler, null) : new HighSecurityX509TrustManager(null));
                SSLContext context = SSLContext.getInstance("SSL");
                context.init(null, new TrustManager[]{tm}, null);
                this.sslcontext = context;
            }
            catch (Exception e) {
                throw new HttpClientError(e.toString());
            }
        }
        return this.sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.getSSLContext(host).getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout2 = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext(host).getSocketFactory();
        if (timeout2 == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout2);
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.getSSLContext(host).getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext(host).getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(SSLProtocolSocketFactory.class);
    }

    public int hashCode() {
        return SSLProtocolSocketFactory.class.hashCode();
    }
}

