/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http.async;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdesktop.dom.SimpleDocument;
import org.jdesktop.dom.SimpleDocumentBuilder;
import org.jdesktop.http.async.AsyncHttpRequest;
import org.w3c.tidy.Tidy;

public final class HtmlHttpRequest
extends AsyncHttpRequest {
    private SimpleDocument responseHtml;

    public final SimpleDocument getResponseHtml() {
        if (this.getReadyState() == AsyncHttpRequest.ReadyState.LOADED) {
            return this.responseHtml;
        }
        return null;
    }

    protected void reset() {
        this.setResponseHtml(null);
        super.reset();
    }

    protected void handleResponse(String responseText) throws Exception {
        if (responseText == null) {
            this.setResponseHtml(null);
        } else {
            try {
                StringBuffer buffer = new StringBuffer(responseText);
                int startIndex = 0;
                while ((startIndex = buffer.indexOf("<script", startIndex)) != -1) {
                    int endIndex;
                    String temp = buffer.substring(startIndex = buffer.indexOf(">", startIndex) + 1, endIndex = buffer.indexOf("</script>", startIndex));
                    if (!temp.contains("&") || temp.startsWith("<![CDATA[")) continue;
                    temp = "<![CDATA[" + temp + "]]>";
                    buffer.replace(startIndex, endIndex, temp);
                }
                responseText = buffer.toString();
                Tidy tidy = new Tidy();
                tidy.setXHTML(true);
                tidy.setSmartIndent(true);
                tidy.setQuoteAmpersand(true);
                ByteArrayInputStream in = new ByteArrayInputStream(responseText.getBytes());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                tidy.parse(in, out);
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                SimpleDocumentBuilder builder = new SimpleDocumentBuilder(f);
                SimpleDocument dom = builder.parseString(out.toString());
                this.setResponseHtml(dom);
            }
            catch (Exception e) {
                this.setResponseHtml(null);
                throw e;
            }
        }
    }

    private void setResponseHtml(SimpleDocument dom) {
        SimpleDocument old = this.responseHtml;
        this.responseHtml = dom;
        this.firePropertyChange("responseHtml", old, this.responseHtml);
    }
}

