/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.http.async;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdesktop.http.Method;
import org.jdesktop.http.async.AsyncHttpRequest;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonHttpRequest
extends AsyncHttpRequest {
    private JSONObject responseJSON;
    private Map<String, Object> responseMap;

    public Map<String, Object> getResponseMap() {
        if (this.getReadyState() == AsyncHttpRequest.ReadyState.LOADED) {
            return this.responseMap;
        }
        return null;
    }

    @Override
    protected void reset() {
        this.setResponseJSON(null);
        this.setResponseMap(null);
        super.reset();
    }

    @Override
    protected void handleResponse(String responseText) throws Exception {
        if (responseText == null) {
            this.setResponseJSON(null);
            this.setResponseMap(null);
        } else {
            try {
                this.setResponseJSON(new JSONObject(responseText));
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.stuffIntoMap(this.responseJSON, map);
                this.setResponseMap(map);
            }
            catch (Exception e) {
                this.setResponseJSON(null);
                this.setResponseMap(null);
                throw e;
            }
        }
    }

    private void stuffIntoMap(JSONObject obj, Map<String, Object> map) {
        if (obj == null) {
            return;
        }
        Iterator itr = obj.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            Object value = obj.opt(key);
            if (value instanceof JSONArray) {
                JSONArray a = (JSONArray)value;
                Object[] array = new Object[a.length()];
                this.stuffIntoArray(a, array);
                map.put(key, array);
                continue;
            }
            if (value instanceof JSONObject) {
                HashMap<String, Object> submap = new HashMap<String, Object>();
                this.stuffIntoMap((JSONObject)value, submap);
                map.put(key, submap);
                continue;
            }
            map.put(key, value);
        }
    }

    private void stuffIntoArray(JSONArray a, Object[] array) {
        if (a == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            Object value = a.opt(i);
            if (value instanceof JSONObject) {
                JSONObject obj = (JSONObject)value;
                HashMap<String, Object> map = new HashMap<String, Object>();
                this.stuffIntoMap(obj, map);
                array[i] = map;
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray ja = (JSONArray)value;
                Object[] o = new Object[ja.length()];
                this.stuffIntoArray(ja, o);
                array[i] = o;
                continue;
            }
            array[i] = value;
        }
    }

    private void setResponseJSON(JSONObject obj) {
        JSONObject old = this.responseJSON;
        this.responseJSON = obj;
        this.firePropertyChange("responseJSON", old, this.responseJSON);
    }

    private void setResponseMap(Map<String, Object> obj) {
        Map<String, Object> old = this.responseMap;
        this.responseMap = obj;
        this.firePropertyChange("responseMap", old, this.responseMap);
    }

    public static void main(String[] args2) {
        final JsonHttpRequest req = new JsonHttpRequest();
        req.addReadyStateChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == AsyncHttpRequest.ReadyState.LOADED) {
                    Map map = (Map)req.getResponseMap().get("ResultSet");
                    System.out.println("Total Results Avail.: " + map.get("totalResultsAvailable"));
                    System.out.println("Results: ");
                    Object[] results2 = (Object[])map.get("Result");
                    for (int i = 0; i < results2.length; ++i) {
                        Map m = (Map)results2[i];
                        System.out.println("\tTitle: " + m.get("Title"));
                    }
                }
            }
        });
        try {
            req.open(Method.GET, "http://api.search.yahoo.com/ImageSearchService/V1/imageSearch?appid=YahooDemo&query=JavaOne&output=json");
            req.send();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

