/*
 * Decompiled with CFR 0.152.
 */
package radio_module;

import device.SensorNode;
import java.io.PrintStream;
import radio_module.RadioModule;
import utilities.UColor;

public class RadioModule_Lora
extends RadioModule {
    protected int spreadingFactor = 7;
    protected int codeRate = 0;

    public RadioModule_Lora(SensorNode sensorNode, String name) {
        super(sensorNode, name);
        this.init();
    }

    @Override
    public void init() {
        this.frequency = 8.68E7;
        this.radioRangeColor1 = UColor.BLUE_TTRANSPARENT;
        this.radioRangeColor2 = UColor.BLUE_TRANSPARENT;
        this.setRadioRangeRadius(5000.0);
        this.setRadioRangeRadiusOri(5000.0);
    }

    @Override
    public int getStandard() {
        return 3;
    }

    @Override
    public String getStandardName() {
        return "LORA";
    }

    @Override
    public double getTransmitPower() {
        double tpW = Math.pow(10.0, this.transmitPower / 10.0) / 1000.0;
        double nTpW = tpW * 1000000.0;
        nTpW = nTpW * this.pl / 100.0;
        double nTpDbm = 10.0 * Math.log10(nTpW / 1000.0);
        return nTpDbm;
    }

    @Override
    public RadioModule duplicate(SensorNode sensorNode) {
        RadioModule_Lora nRadioModule = new RadioModule_Lora(sensorNode, this.name);
        nRadioModule.setMy(this.getMy());
        nRadioModule.setCh(this.getCh());
        nRadioModule.setNId(this.getNId());
        nRadioModule.setRadioRangeRadius(this.getRadioRangeRadius());
        nRadioModule.setETx(this.getETx());
        nRadioModule.setERx(this.getERx());
        nRadioModule.setESleep(this.getESleep());
        nRadioModule.setEListen(this.getEListen());
        nRadioModule.setRadioDataRate(this.getRadioDataRate());
        ((RadioModule)nRadioModule).setSpreadingFactor(this.getSpreadingFactor());
        ((RadioModule)nRadioModule).setCodeRate(this.getCodeRate());
        nRadioModule.setRadioConsoTxModel(this.getRadioConsoTxModel());
        nRadioModule.setRadioConsoRxModel(this.getRadioConsoRxModel());
        return nRadioModule;
    }

    public static String getPayLoad(String data) {
        return "";
    }

    @Override
    public void save(PrintStream fos, RadioModule currentRadioModule) {
        if (currentRadioModule.getName().equals(this.getName())) {
            fos.println("current_radio_name:" + this.getName());
        } else {
            fos.println("radio_name:" + this.getName());
        }
        fos.println("radio_standard:" + this.getStandardName());
        fos.println("radio_my:" + this.getMy());
        fos.println("radio_channel:" + this.getCh());
        fos.println("radio_network_id:" + this.getNId());
        fos.println("radio_radius:" + this.getRadioRangeRadius());
        fos.println("radio_etx:" + this.getETx());
        fos.println("radio_erx:" + this.getERx());
        fos.println("radio_esleep:" + this.getESleep());
        fos.println("radio_elisten:" + this.getEListen());
        fos.println("radio_data_rate:" + this.getRadioDataRate());
        fos.println("spreading_factor:" + this.getSpreadingFactor());
        fos.println("code_rate:" + this.getCodeRate());
        fos.println("conso_tx_model:" + this.getRadioConsoTxModel());
        fos.println("conso_rx_model:" + this.getRadioConsoRxModel());
    }

    @Override
    public int getSpreadingFactor() {
        return this.spreadingFactor;
    }

    @Override
    public void setSpreadingFactor(int spreadingFactor) {
        this.spreadingFactor = spreadingFactor;
    }

    @Override
    public int getCodeRate() {
        return this.codeRate;
    }

    @Override
    public void setCodeRate(int codeRate) {
        this.codeRate = codeRate;
    }
}

