/*
 * Decompiled with CFR 0.152.
 */
package senscript;

import device.SensorNode;
import markers.Routes;
import senscript.Command;
import simulation.WisenSimulation;

public class Command_ROUTE2
extends Command {
    protected String arg1 = "";
    private boolean once = false;

    public Command_ROUTE2(SensorNode sensor, String arg1) {
        this.sensor = sensor;
        this.arg1 = arg1;
    }

    @Override
    public double execute() {
        String route2 = this.sensor.getScript().getVariableValue(this.arg1);
        String gpsFileName = this.sensor.getGPSFileName();
        String route1 = gpsFileName.substring(0, gpsFileName.indexOf(46));
        int closeIdx = 0;
        int n = Routes.numberOfClosestNodes(this.sensor.getRouteIndex(), Routes.getRouteByName(route1), closeIdx, Routes.getRouteByName(route2));
        System.out.println(n);
        if (!this.once) {
            this.executing = true;
            this.once = true;
            return n;
        }
        this.executing = false;
        this.once = false;
        WisenSimulation.simLog.add("S" + this.sensor.getId() + " ROUTE: " + route2 + " " + gpsFileName + " " + route1 + " " + closeIdx + " " + n);
        this.sensor.setRoute(route2);
        this.sensor.loadRouteFromFile();
        this.sensor.setRouteIndex(closeIdx);
        return 0.0;
    }

    @Override
    public String toString() {
        return "ROUTE";
    }
}

