/*
 * Decompiled with CFR 0.152.
 */
package solver;

import device.DeviceList;
import device.SensorNode;
import java.util.Vector;
import map.MapLayer;

public class CycleFromNode
extends Thread {
    protected int delayTime = 200;
    int b = 0;

    @Override
    public void run() {
        Vector<SensorNode> nodes = DeviceList.sensors;
        DeviceList.initAll();
        DeviceList.addHull();
        DeviceList.initLastHull();
        SensorNode n = (SensorNode)nodes.get(0);
        System.out.println(this.cycle(false, n, n));
        DeviceList.addToLastHull(DeviceList.sensors.indexOf(n));
        MapLayer.repaint();
    }

    public boolean cycle(boolean result, SensorNode n, SensorNode refNode) {
        SensorNode next;
        if (result) {
            return true;
        }
        System.out.println(String.valueOf(n) + " " + String.valueOf(refNode));
        this.delay();
        if (n.isMarked()) {
            return n == refNode;
        }
        n.setMarked(true);
        DeviceList.addToLastHull(DeviceList.sensors.indexOf(n));
        MapLayer.repaint();
        while ((next = this.getNextUnmarkedNode(n, refNode)) != null) {
            System.out.println(String.valueOf(n) + " -> " + String.valueOf(next));
            if (next == refNode) {
                System.out.println("A");
                this.cycle(true, next, refNode);
                continue;
            }
            this.cycle(false, next, refNode);
        }
        return false;
    }

    public SensorNode getNextUnmarkedNode(SensorNode n, SensorNode ref) {
        SensorNode next = null;
        for (SensorNode node : n.getNeighbors()) {
            if (this.b > 1 && node == ref) {
                return node;
            }
            if (node.isMarked()) continue;
            next = node;
        }
        ++this.b;
        return next;
    }

    public void delay() {
        try {
            CycleFromNode.sleep(this.delayTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

