/*
 * Decompiled with CFR 0.152.
 */
package solver;

import device.DeviceList;
import device.DeviceWithRadio;
import device.SensorNode;
import java.util.Vector;
import map.MapLayer;

public class NetworkEnvelope2
extends Thread {
    private boolean withoutRadioDetect = true;

    public NetworkEnvelope2() {
        this.withoutRadioDetect = true;
    }

    public NetworkEnvelope2(boolean withoutRadioDetect) {
        this.withoutRadioDetect = withoutRadioDetect;
    }

    @Override
    public void run() {
        int i;
        int k = 1;
        int rank1 = 0;
        int rank2 = 0;
        int rank3 = 0;
        int rank4 = 0;
        int rank5 = 0;
        int rank6 = 0;
        int rank7 = 0;
        int rank8 = 0;
        Vector<SensorNode> nodes = DeviceList.sensors;
        for (i = 0; i < nodes.size(); ++i) {
            ((SensorNode)nodes.get(i)).setValue(0.0);
            ((SensorNode)nodes.get(i)).setMarked(false);
        }
        for (i = 0; i < nodes.size(); ++i) {
            DeviceWithRadio n1 = (DeviceWithRadio)nodes.get(i);
            rank1 = 0;
            rank2 = 0;
            rank3 = 0;
            rank4 = 0;
            rank5 = 0;
            rank6 = 0;
            rank7 = 0;
            rank8 = 0;
            for (int j = 0; j < nodes.size(); ++j) {
                if (i == j) continue;
                DeviceWithRadio n2 = (DeviceWithRadio)nodes.get(j);
                double x1 = n1.getLatitude();
                double y1 = n1.getLongitude();
                double x2 = n2.getLatitude();
                double y2 = n2.getLongitude();
                double ay1 = -x2 + (x1 + y1);
                double ay2 = x2 + (y1 - x1);
                if (!n1.radioDetect(n2) && !this.withoutRadioDetect) continue;
                if (n1.getLongitude() < n2.getLongitude() && n1.getLatitude() < n2.getLatitude()) {
                    ++rank1;
                }
                if (n1.getLongitude() > n2.getLongitude() && n1.getLatitude() < n2.getLatitude()) {
                    ++rank2;
                }
                if (n1.getLongitude() > n2.getLongitude() && n1.getLatitude() > n2.getLatitude()) {
                    ++rank3;
                }
                if (n1.getLongitude() < n2.getLongitude() && n1.getLatitude() > n2.getLatitude()) {
                    ++rank4;
                }
                if (y2 > ay1 && y2 < ay2) {
                    ++rank5;
                }
                if (y2 > ay1 && y2 > ay2) {
                    ++rank6;
                }
                if (y2 < ay1 && y2 > ay2) {
                    ++rank7;
                }
                if (!(y2 < ay1) || !(y2 < ay2)) continue;
                ++rank8;
            }
            if (rank1 < k || rank2 < k || rank3 < k || rank4 < k) {
                n1.setMarked(true);
                DeviceList.addToLastHull(i);
            } else if (rank5 < k || rank6 < k || rank7 < k || rank8 < k) {
                n1.setMarked(true);
                DeviceList.addToLastHull(i);
            }
            MapLayer.repaint();
        }
        System.out.println("Finish !");
    }
}

