/*
 * Decompiled with CFR 0.152.
 */
package solver;

import device.Device;
import device.DeviceList;
import java.util.LinkedList;
import map.MapLayer;

public class NetworkEnvelopeC
extends Thread {
    private LinkedList<Integer> envelope = null;

    @Override
    public void run() {
        double y;
        double x;
        double angle;
        Device node;
        DeviceList.initAll();
        DeviceList.addHull();
        this.envelope = DeviceList.getLastHull();
        double min = 1.0E7;
        int imin = 0;
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            DeviceList.sensors.get(i).setValue(0.0);
            DeviceList.sensors.get(i).setVisited(false);
            DeviceList.sensors.get(i).setMarked(false);
            if (!(min > DeviceList.sensors.get(i).getLatitude())) continue;
            min = DeviceList.sensors.get(i).getLatitude();
            imin = i;
        }
        DeviceList.sensors.get(imin).setMarked(true);
        DeviceList.sensors.get(imin).setVisited(true);
        this.envelope.add(imin);
        MapLayer.repaint();
        double x0 = DeviceList.sensors.get(imin).getLatitude();
        double y0 = DeviceList.sensors.get(imin).getLongitude();
        this.delay();
        min = 1.0E7;
        imin = -1;
        int n = DeviceList.sensors.size() - 1;
        for (int j = 0; j < DeviceList.sensors.size(); ++j) {
            node = DeviceList.sensors.get(j);
            if (j == this.envelope.getFirst() || node.isVisited() || !((angle = this.getAngle(x0, y0, x = node.getLatitude(), y = node.getLongitude())) < min)) continue;
            min = angle;
            imin = j;
        }
        DeviceList.sensors.get(imin).setMarked(true);
        DeviceList.sensors.get(imin).setVisited(true);
        this.envelope.add(imin);
        MapLayer.repaint();
        this.delay();
        for (int i = 0; i < DeviceList.sensors.size() - 2; ++i) {
            min = 1.0E7;
            imin = -1;
            for (int j = 0; j < DeviceList.sensors.size(); ++j) {
                node = DeviceList.sensors.get(j);
                if (j == this.envelope.getLast() || node.isVisited() || !((angle = this.getAngle(x0, y0, x = node.getLatitude(), y = node.getLongitude())) < min)) continue;
                min = angle;
                imin = j;
            }
            DeviceList.sensors.get(imin).setMarked(true);
            DeviceList.sensors.get(imin).setVisited(true);
            MapLayer.repaint();
            this.envelope.add(imin);
            n = this.envelope.size() - 1;
            double px1 = DeviceList.sensors.get(this.envelope.get(n - 2)).getLatitude();
            double py1 = DeviceList.sensors.get(this.envelope.get(n - 2)).getLongitude();
            double px2 = DeviceList.sensors.get(this.envelope.get(n - 1)).getLatitude();
            double py2 = DeviceList.sensors.get(this.envelope.get(n - 1)).getLongitude();
            double px3 = DeviceList.sensors.get(this.envelope.get(n)).getLatitude();
            double py3 = DeviceList.sensors.get(this.envelope.get(n)).getLongitude();
            boolean r = this.right(px1 - px2, py1 - py2, px3 - px2, py3 - py2);
            while (!r) {
                DeviceList.sensors.get(this.envelope.get(n - 1)).setMarked(false);
                MapLayer.repaint();
                this.envelope.remove(n - 1);
                if (--n > 0) {
                    px1 = DeviceList.sensors.get(this.envelope.get(n - 2)).getLatitude();
                    py1 = DeviceList.sensors.get(this.envelope.get(n - 2)).getLongitude();
                    px2 = DeviceList.sensors.get(this.envelope.get(n - 1)).getLatitude();
                    py2 = DeviceList.sensors.get(this.envelope.get(n - 1)).getLongitude();
                    px3 = DeviceList.sensors.get(this.envelope.get(n)).getLatitude();
                    py3 = DeviceList.sensors.get(this.envelope.get(n)).getLongitude();
                    r = this.right(px1 - px2, py1 - py2, px3 - px2, py3 - py2);
                } else {
                    r = true;
                }
                this.delay();
            }
            this.delay();
        }
        MapLayer.repaint();
        System.out.println("---------------------------");
        System.out.println(" F I N I S H");
        System.out.println("---------------------------");
    }

    public double getAngle(double x1, double y1, double x2, double y2) {
        double a = Math.atan2(x2 -= x1, y2 -= y1);
        if (a < 0.0) {
            a = Math.PI * 2 + a;
        }
        return a;
    }

    public boolean right2(double x1, double y1, double x2, double y2) {
        double b = x1 * y2 - x2 * y1;
        return b > 0.0;
    }

    public boolean right(double x1, double y1, double x2, double y2) {
        double b;
        double a = Math.atan2(x1, y1);
        if (a < 0.0) {
            a = Math.PI * 2 + a;
        }
        if ((b = Math.atan2(x2, y2)) < 0.0) {
            b = Math.PI * 2 + b;
        }
        if ((b -= a) < 0.0) {
            b = Math.PI * 2 + b;
        }
        return Math.toDegrees(b) > 180.0;
    }

    public double getAngle2(double x1, double y1, double x2, double y2) {
        double b;
        double a = Math.atan2(x1, y1);
        if (a < 0.0) {
            a = Math.PI * 2 + a;
        }
        if ((b = Math.atan2(x2, y2)) < 0.0) {
            b = Math.PI * 2 + b;
        }
        if ((b -= a) < 0.0) {
            b = Math.PI * 2 + b;
        }
        return b;
    }

    public void delay() {
        try {
            NetworkEnvelopeC.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

