/*
 * Decompiled with CFR 0.152.
 */
package solver;

import device.DeviceList;
import device.SensorNode;
import device.StdSensorNode;
import map.MapLayer;

public class NetworkEnvelopeHTmp
extends Thread {
    @Override
    public void run() {
        double x0 = 0.0;
        double y0 = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double xc = 0.0;
        double yc = 0.0;
        double angle = 0.0;
        int cur = 0;
        int prem = 0;
        int prec = 0;
        double min = 0.0;
        int imin = 0;
        boolean fini = false;
        DeviceList.initAll();
        DeviceList.addHull();
        DeviceList.initLastHull();
        min = 1.0E7;
        imin = 0;
        for (int i = 0; i < DeviceList.sensors.size(); ++i) {
            DeviceList.sensors.get(i).setValue(0.0);
            DeviceList.sensors.get(i).setMarked(false);
            if (DeviceList.sensors.get(i).isDead() || !(min > DeviceList.sensors.get(i).getLatitude())) continue;
            min = DeviceList.sensors.get(i).getLatitude();
            imin = i;
        }
        prem = imin;
        prec = imin;
        cur = imin;
        DeviceList.sensors.get(imin).setMarked(true);
        MapLayer.repaint();
        DeviceList.addToLastHull(imin);
        this.delay();
        SensorNode n1 = DeviceList.sensors.get(cur);
        xc = n1.getLatitude();
        yc = n1.getLongitude();
        x0 = xc - 0.2;
        y0 = yc - 0.2;
        StdSensorNode n3 = new StdSensorNode(y0, x0, 0.0, 10.0, 10.0, -1);
        x1 = xc - 0.1;
        y1 = yc;
        SensorNode n4 = new StdSensorNode(y1, x1, 0.0, 10.0, 10.0, -1);
        fini = false;
        while (!fini) {
            min = 1.0E7;
            for (int j = 0; j < DeviceList.sensors.size(); ++j) {
                SensorNode n2 = DeviceList.sensors.get(j);
                if (DeviceList.sensors.get(j).isDead() || cur == j || !n1.radioDetect(n2) || j == prec) continue;
                x2 = n2.getLatitude();
                y2 = n2.getLongitude();
                angle = this.getAngle(x1 - xc, y1 - yc, x2 - xc, y2 - yc);
                boolean b1 = NetworkEnvelopeHTmp.intersect(x0, y0, x1, y1, xc, yc, x2, y2);
                boolean b3 = n3.radioDetect(n4);
                if (!(angle < min) || b1 && b3) continue;
                imin = j;
                min = angle;
            }
            if (imin == prem) {
                fini = true;
            }
            prec = cur;
            DeviceList.sensors.get(imin).setMarked(true);
            MapLayer.repaint();
            DeviceList.addToLastHull(imin);
            n3 = n4;
            n4 = n1;
            n1 = DeviceList.sensors.get(imin);
            cur = imin;
            x0 = x1;
            y0 = y1;
            x1 = xc;
            y1 = yc;
            xc = DeviceList.sensors.get(imin).getLatitude();
            yc = DeviceList.sensors.get(imin).getLongitude();
            this.delay();
        }
        System.out.println("FINISH !");
    }

    public double getAngle1(double x1, double y1, double x2, double y2) {
        double a = Math.atan2(x2 -= x1, y2 -= y1);
        if (a < 0.0) {
            a = Math.PI * 2 + a;
        }
        return a;
    }

    public double getAngle(double x1, double y1, double x2, double y2) {
        double b;
        double a = Math.atan2(x1, y1);
        if (a < 0.0) {
            a = Math.PI * 2 + a;
        }
        if ((b = Math.atan2(x2, y2)) < 0.0) {
            b = Math.PI * 2 + b;
        }
        if ((b -= a) < 0.0) {
            b = Math.PI * 2 + b;
        }
        return b;
    }

    public static boolean intersect(double p0_x, double p0_y, double p1_x, double p1_y, double p2_x, double p2_y, double p3_x, double p3_y) {
        double s1_x = p1_x - p0_x;
        double s1_y = p1_y - p0_y;
        double s2_x = p3_x - p2_x;
        double s2_y = p3_y - p2_y;
        double s = (-s1_y * (p0_x - p2_x) + s1_x * (p0_y - p2_y)) / (-s2_x * s1_y + s1_x * s2_y);
        double t = (s2_x * (p0_y - p2_y) - s2_y * (p0_x - p2_x)) / (-s2_x * s1_y + s1_x * s2_y);
        return s > 0.0 && s < 1.0 && t > 0.0 && t < 1.0;
    }

    public void delay() {
        try {
            NetworkEnvelopeHTmp.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

