/*
 * Decompiled with CFR 0.152.
 */
package solver;

import device.Device;
import device.DeviceList;
import device.SensorNode;
import graph.Graph;
import graph.Vertex;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import map.MapLayer;

public class SensorTargetCoverageRun
implements Runnable {
    public static Graph toSensorTargetGraph(List<Device> nodes, int size) {
        Device n1 = null;
        Device n2 = null;
        Graph graph = new Graph();
        int i = 0;
        int j = 0;
        ListIterator<Device> iterator2 = nodes.listIterator();
        while (iterator2.hasNext()) {
            n1 = iterator2.next();
            if (n1.getType() != 1 || !n1.getState()) continue;
            graph.add(new Vertex(i++, n1.getName()));
            n1.setMarked(false);
        }
        iterator2 = nodes.listIterator();
        i = 0;
        while (iterator2.hasNext() && iterator2.nextIndex() < size - 1) {
            n1 = iterator2.next();
            if (n1.getType() != 1) continue;
            ListIterator<Device> iterator22 = nodes.listIterator();
            j = 0;
            while (iterator22.hasNext()) {
                n2 = iterator22.next();
                if (((SensorNode)n1).detect(n2) && n2.getType() != 1 && n2.getState()) {
                    graph.get(i).addNeighbor(j);
                }
                ++j;
            }
            ++i;
        }
        return graph;
    }

    public static void sensorTargetSetCover() {
        Graph graph = null;
        Vector<Device> nodes = DeviceList.devices;
        graph = SensorTargetCoverageRun.toSensorTargetGraph(nodes, DeviceList.sensorListSize());
        int ng = graph.size();
        for (int i = 0; i < ng; ++i) {
            if (graph.get(i).getNbNeignbors() != 0) continue;
            graph.remove(i);
            --i;
            --ng;
        }
        while (graph.size() > 0) {
            int max = graph.get(0).getNbNeignbors();
            int imax = 0;
            for (int i = 1; i < graph.size(); ++i) {
                if (max >= graph.get(i).getNbNeignbors()) continue;
                max = graph.get(i).getNbNeignbors();
                imax = i;
            }
            ((Device)nodes.get(graph.get(imax).getNumber())).setMarked(true);
            graph.removeWithNeighbors(imax);
        }
        MapLayer.repaint();
    }

    public void start() {
        Thread th = new Thread(this);
        th.start();
    }

    @Override
    public void run() {
        while (true) {
            SensorTargetCoverageRun.sensorTargetSetCover();
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

