/*
 * Decompiled with CFR 0.152.
 */
package visibility;

import buildings.Building;
import buildings.BuildingList;
import device.DeviceList;
import device.SensorNode;
import geo_objects.GeoZone;
import geo_objects.GeoZoneList;
import java.util.ArrayList;
import map.MapLayer;
import math.Angle;

public class VisibilityZones
extends Thread {
    private SensorNode sensorNode;

    public VisibilityZones(SensorNode sensorNode) {
        this.sensorNode = sensorNode;
    }

    @Override
    public void run() {
        ArrayList<double[]> visibilityPointList = new ArrayList<double[]>();
        int nPoint = 20;
        GeoZone zoneOfInterest = new GeoZone(nPoint);
        double step = Math.PI * 2 / (double)nPoint;
        double deg = 0.0;
        for (int i = 0; i < nPoint; ++i) {
            if (this.sensorNode.getCurrentRadioModule().getStandard() == 1) {
                zoneOfInterest.set(this.sensorNode.getLatitude() + 0.001 * Math.cos(deg), this.sensorNode.getLongitude() + 0.0015 * Math.sin(deg), 0.0, i);
            }
            if (this.sensorNode.getCurrentRadioModule().getStandard() == 3) {
                zoneOfInterest.set(this.sensorNode.getLatitude() + 0.05 * Math.cos(deg), this.sensorNode.getLongitude() + 0.075 * Math.sin(deg), 0.0, i);
            }
            deg += step;
        }
        ArrayList<Building> buildings = new ArrayList<Building>();
        for (Building building : BuildingList.buildings) {
            if (!(this.sensorNode.getElevation() < building.getHeight()) || !building.intersect(zoneOfInterest)) continue;
            buildings.add(building);
        }
        for (Building building : buildings) {
            double z = building.getHeight();
            for (int i = 0; i < building.getNPoints(); ++i) {
                double[] t = new double[]{building.getYCoords(i), building.getXCoords(i)};
                if (!(this.sensorNode.distance(t[1], t[0]) < this.sensorNode.getCurrentRadioRangeRadius())) continue;
                boolean intersection = false;
                if (this.sensorNode.getElevation() < z) {
                    for (Building building2 : buildings) {
                        if (!building2.intersect(this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), t[0], t[1])) continue;
                        intersection = true;
                        break;
                    }
                }
                if (intersection) continue;
                visibilityPointList.add(t);
            }
        }
        for (int k = 0; k < nPoint; ++k) {
            boolean intersection = false;
            for (Building building : buildings) {
                if (!building.intersect(zoneOfInterest) || !building.intersect(this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), zoneOfInterest.getXCoord(k), zoneOfInterest.getYCoord(k))) continue;
                intersection = true;
                break;
            }
            if (intersection) continue;
            visibilityPointList.add(new double[]{zoneOfInterest.getXCoord(k), zoneOfInterest.getYCoord(k)});
        }
        for (int i = 0; i < visibilityPointList.size() - 1; ++i) {
            for (int j = i + 1; j < visibilityPointList.size(); ++j) {
                double a2;
                double a1 = Angle.getAngle(this.sensorNode.getLongitude() - 100.0, this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), this.sensorNode.getLatitude(), ((double[])visibilityPointList.get(i))[1], ((double[])visibilityPointList.get(i))[0]);
                if (!(a1 > (a2 = Angle.getAngle(this.sensorNode.getLongitude() - 100.0, this.sensorNode.getLatitude(), this.sensorNode.getLongitude(), this.sensorNode.getLatitude(), ((double[])visibilityPointList.get(j))[1], ((double[])visibilityPointList.get(j))[0])))) continue;
                double px = ((double[])visibilityPointList.get(i))[0];
                double py = ((double[])visibilityPointList.get(i))[1];
                ((double[])visibilityPointList.get((int)i))[0] = ((double[])visibilityPointList.get(j))[0];
                ((double[])visibilityPointList.get((int)i))[1] = ((double[])visibilityPointList.get(j))[1];
                ((double[])visibilityPointList.get((int)j))[0] = px;
                ((double[])visibilityPointList.get((int)j))[1] = py;
            }
        }
        GeoZone zone = new GeoZone(visibilityPointList.size());
        zone.setCxCy(this.sensorNode.getLongitude(), this.sensorNode.getLatitude());
        int k = 0;
        for (double[] v : visibilityPointList) {
            zone.set(v[0], v[1], 0.0, k++);
        }
        GeoZoneList geoZoneList = new GeoZoneList();
        geoZoneList.add(zone);
        this.sensorNode.setGeoZoneList(geoZoneList);
        DeviceList.calculatePropagations();
        MapLayer.repaint();
    }
}

